@echo off
title CLSTEAM SAFE PRIVACY MODE
setlocal enabledelayedexpansion

:: Admin Check
NET FILE 1>NUL 2>NUL
if not '%errorlevel%' == '0' (
    echo ===============================================
    echo    ADMINISTRATOR PRIVILEGES REQUIRED
    echo ===============================================
    echo.
    echo This script must be run as Administrator!
    echo.
    echo Please right-click on the script and select:
    echo "Run as administrator"
    echo.
    echo Press any key to exit...
    pause >nul
    exit /b 1
)

:Main
cls
echo ===============================================
echo    CLSTEAM SAFE PRIVACY MODE
echo ===============================================
echo.
echo Starting safe privacy protection process...
echo This will NOT break any system functionality!
echo.
timeout /t 2 /nobreak >nul

:: Disable Telemetry and Data Collection (Safe)
echo [1/25] Reducing Telemetry and Data Collection...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\DataCollection" /v "AllowTelemetry" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Basic telemetry disabled
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\DataCollection" /v "AllowTelemetry" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Telemetry registry disabled
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\DataCollection" /v "DoNotShowFeedbackNotifications" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Feedback notifications disabled
echo [SUCCESS] Telemetry reduced safely
echo.

:: Stop Non-Essential Telemetry Services
echo [2/25] Optimizing Telemetry Services...
sc config "dmwappushservice" start= disabled >nul 2>&1 && echo   - WAP Push Message Routing disabled
sc stop "dmwappushservice" >nul 2>&1 && echo   - WAP Push service stopped
echo [SUCCESS] Non-essential telemetry services optimized
echo.

:: Disable Cortana Data Collection (Safe)
echo [3/25] Disabling Cortana Data Collection...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\Windows Search" /v "AllowCortana" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Cortana disabled
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\Windows Search" /v "AllowSearchToUseLocation" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Search location disabled
echo [SUCCESS] Cortana data collection disabled
echo.

:: Disable Location Tracking (Safe)
echo [4/25] Disabling Location Tracking...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\LocationAndSensors" /v "DisableLocation" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Location services disabled
reg add "HKCU\SOFTWARE\Microsoft\Windows\CurrentVersion\DeviceAccess\Global\LoCAtIOn" /v "Value" /t REG_SZ /d "Deny" /f >nul 2>&1 && echo   - Device location access denied
echo [SUCCESS] Location tracking disabled safely
echo.

:: Disable Advertising ID
echo [5/25] Disabling Advertising ID...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\AdvertisingInfo" /v "DisabledByGroupPolicy" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Advertising ID disabled
reg add "HKCU\SOFTWARE\Microsoft\Windows\CurrentVersion\AdvertisingInfo" /v "Enabled" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Advertising ID registry disabled
echo [SUCCESS] Advertising ID disabled
echo.

:: Disable Tailored Experiences
echo [6/25] Disabling Tailored Experiences...
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\Privacy" /v "TailoredExperiencesWithDiagnosticDataEnabled" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Tailored experiences disabled
echo [SUCCESS] Tailored experiences disabled
echo.

:: Disable Activity History
echo [7/25] Disabling Activity History...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\System" /v "PublishUserActivities" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - User activities publishing disabled
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\System" /v "UploadUserActivities" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - User activities upload disabled
echo [SUCCESS] Activity history disabled
echo.

:: Disable Timeline Feature
echo [8/25] Disabling Timeline...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\System" /v "EnableActivityFeed" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Activity feed disabled
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\System" /v "EnableCdp" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Cross-device experiences disabled
echo [SUCCESS] Timeline feature disabled
echo.

:: Disable Windows Tips and Suggestions
echo [9/25] Disabling Windows Tips...
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" /v "SubscribedContent-338387Enabled" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Tips and tricks disabled
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" /v "SubscribedContent-353694Enabled" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Tips about Windows changes disabled
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" /v "SubscribedContent-353696Enabled" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Tips and suggestions disabled
echo [SUCCESS] Windows tips and suggestions disabled
echo.

:: Disable Feedback Requests
echo [10/25] Disabling Feedback Requests...
reg add "HKCU\Software\Microsoft\Siuf\Rules" /v "NumberOfSIUFInPeriod" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Feedback requests disabled
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\DataCollection" /v "DoNotShowFeedbackNotifications" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Feedback notifications disabled
echo [SUCCESS] Feedback requests disabled
echo.

:: Disable Diagnostic Data
echo [11/25] Disabling Diagnostic Data...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\DataCollection" /v "AllowDeviceNameInTelemetry" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Device name in telemetry disabled
echo [SUCCESS] Diagnostic data disabled
echo.

:: Disable Windows Update Sharing (P2P)
echo [12/25] Disabling Windows Update P2P Sharing...
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\DeliveryOptimization" /v "SystemSettingsDownloadMode" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Delivery optimization disabled
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\DeliveryOptimization" /v "DODownloadMode" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Download mode disabled
echo [SUCCESS] Windows Update P2P sharing disabled
echo.

:: Disable SmartScreen Filter for Store Apps Only
echo [13/25] Optimizing SmartScreen Filter...
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\AppHost" /v "EnableWebContentEvaluation" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Web content evaluation disabled
echo [SUCCESS] SmartScreen optimized
echo.

:: Disable Error Reporting
echo [14/25] Disabling Error Reporting...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\Windows Error Reporting" /v "Disabled" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Windows Error Reporting disabled
sc config "WerSvc" start= disabled >nul 2>&1 && echo   - Windows Error Reporting service disabled
sc stop "WerSvc" >nul 2>&1 && echo   - Error Reporting service stopped
echo [SUCCESS] Error reporting disabled
echo.

:: Disable Customer Experience Improvement Program
echo [15/25] Disabling CEIP...
reg add "HKLM\SOFTWARE\Policies\Microsoft\SQMClient\Windows" /v "CEIPEnable" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Customer Experience Improvement Program disabled
echo [SUCCESS] Customer Experience Improvement Program disabled
echo.

:: Disable Application Telemetry
echo [16/25] Disabling Application Telemetry...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\AppCompat" /v "AITEnable" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Application Telemetry disabled
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\AppCompat" /v "DisableUAR" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - User Activity Recording disabled
echo [SUCCESS] Application telemetry disabled
echo.

:: Disable Compatibility Telemetry
echo [17/25] Disabling Compatibility Telemetry...
schtasks /change /tn "Microsoft\Windows\Application Experience\Microsoft Compatibility Appraiser" /disable >nul 2>&1 && echo   - Compatibility appraiser disabled
schtasks /change /tn "Microsoft\Windows\Application Experience\ProgramDataUpdater" /disable >nul 2>&1 && echo   - Program data updater disabled
echo [SUCCESS] Compatibility telemetry disabled
echo.

:: Disable Inventory Collection
echo [18/25] Disabling Inventory Collection...
schtasks /change /tn "Microsoft\Windows\Application Experience\AitAgent" /disable >nul 2>&1 && echo   - AIT Agent disabled
schtasks /change /tn "Microsoft\Windows\Customer Experience Improvement Program\Consolidator" /disable >nul 2>&1 && echo   - CEIP Consolidator disabled
echo [SUCCESS] Inventory collection disabled
echo.

:: Disable NCSI (Network Connectivity Status Indicator)
echo [19/25] Disabling NCSI...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\NetworkConnectivityStatusIndicator" /v "NoActiveProbe" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Active probing disabled
echo [SUCCESS] NCSI disabled
echo.

:: Disable Windows Spotlight
echo [20/25] Disabling Windows Spotlight...
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" /v "ContentDeliveryAllowed" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Content delivery disabled
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" /v "SubscribedContent-338387Enabled" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Windows Spotlight disabled
echo [SUCCESS] Windows Spotlight disabled
echo.

:: Disable Xbox Features
echo [21/25] Disabling Xbox Features...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\GameDVR" /v "AllowGameDVR" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Game DVR disabled
reg add "HKCU\System\GameConfigStore" /v "GameDVR_Enabled" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Game DVR user setting disabled
echo [SUCCESS] Xbox features disabled
echo.

:: Disable Handwriting Data Sharing
echo [22/25] Disabling Handwriting Data Sharing...
reg add "HKLM\SOFTWARE\Policies\Microsoft\InputPersonalization" /v "AllowInputPersonalization" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Input personalization disabled
echo [SUCCESS] Handwriting data sharing disabled
echo.

:: Clear Existing Telemetry Data
echo [23/25] Clearing Existing Telemetry Data...
del /f /s /q /a "%windir%\System32\config\systemprofile\AppData\Local\Microsoft\Windows\WER\*" >nul 2>&1 && echo   - Error reporting data cleared
echo [SUCCESS] Existing telemetry data cleared
echo.

:: Create Privacy Monitor Tool
echo [24/25] Creating Privacy Monitor Tool...
echo @echo off > "%TEMP%\Safe_Privacy_Monitor.bat"
echo echo CLSTEAM Safe Privacy Monitor >> "%TEMP%\Safe_Privacy_Monitor.bat"
echo echo ============================= >> "%TEMP%\Safe_Privacy_Monitor.bat"
echo echo. >> "%TEMP%\Safe_Privacy_Monitor.bat"
echo echo Privacy Status Check: >> "%TEMP%\Safe_Privacy_Monitor.bat"
echo echo Telemetry Services: >> "%TEMP%\Safe_Privacy_Monitor.bat"
echo sc query DiagTrack ^| findstr "STATE" >> "%TEMP%\Safe_Privacy_Monitor.bat"
echo sc query dmwappushservice ^| findstr "STATE" >> "%TEMP%\Safe_Privacy_Monitor.bat"
echo echo. >> "%TEMP%\Safe_Privacy_Monitor.bat"
echo echo Press any key to exit... >> "%TEMP%\Safe_Privacy_Monitor.bat"
echo pause >nul >> "%TEMP%\Safe_Privacy_Monitor.bat"
echo [SUCCESS] Privacy monitor tool created
echo.

:: Final Cleanup
echo [25/25] Performing Final Cleanup...
echo Flushing DNS and refreshing system...
ipconfig /flushdns >nul 2>&1 && echo   - DNS cache flushed
echo Restarting Explorer...
taskkill /f /im explorer.exe >nul 2>&1
timeout /t 2 /nobreak >nul
start explorer.exe >nul 2>&1
echo [SUCCESS] Cleanup completed
echo.

:: Completion Message
echo ===============================================
echo    SAFE PRIVACY MODE COMPLETE!
echo ===============================================
echo.
echo SUCCESS: Your PC privacy has been enhanced safely!
echo.
echo Privacy Features Enabled:
echo ✓ Telemetry and data collection reduced
echo ✓ Location tracking disabled
echo ✓ Advertising ID and tracking removed
echo ✓ Cortana data collection stopped
echo ✓ Activity history and Timeline disabled
echo ✓ Windows tips and suggestions removed
echo ✓ Feedback requests disabled
echo ✓ Error reporting and diagnostics disabled
echo ✓ Windows Spotlight disabled
echo ✓ Xbox features disabled
echo ✓ Handwriting data sharing disabled
echo ✓ Existing telemetry data cleared
echo.
echo Privacy Benefits:
echo - Reduced data collection by Microsoft
echo - No location tracking
echo - No advertising tracking
echo - No usage data sharing
echo - Better control over your privacy
echo.
echo Performance Benefits:
echo - Reduced background processes
echo - Less network usage
echo - More system resources available
echo - Maintained system stability
echo.
echo Additional Tools Created:
echo - %TEMP%\Safe_Privacy_Monitor.bat : Check privacy status
echo.
echo CLSTEAM SAFE PRIVACY MODE
echo Privacy protection completed at: %date% %time%
echo ===============================================
echo.
echo Press Enter to exit...
pause >nul
exit